IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_SAI_DAR_IT]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[EST_NF_SAI_DAR_IT](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_IT] [int] NOT NULL,
	[CD_DAR] [int] NOT NULL,
	[VLR_BASE_ICMS] [money] NOT NULL,
	[VLR_ICMS_SUBS] [money] NOT NULL,
	[VLR_BASE_SUBS] [money] NOT NULL,
	[VLR_ICMS] [money] NOT NULL,
	[PERC_ICMS] [money] NOT NULL,
	[PERC_IVA] [money] NOT NULL,
	[VLR_ICMS_DIFERENCIAL] [money] NOT NULL,
	[CD_TRIB] [int] NOT NULL,
	[CD_NT_OP] [int] NOT NULL,
	[VLR_CUSTO] [money] NOT NULL,
	[PERC_RED_BASE_ICMS] [money] NOT NULL,
	[PERC_RED_BASE_SUBS] [money] NOT NULL,
	[PERC_ICMS_DESTINO] [money] NOT NULL,
	[VLR_PMC] [money] NULL,
	[VLR_BASE_ICMS_RETIDO] [money] NULL,
	[VLR_ICMS_RETIDO] [money] NULL,
 CONSTRAINT [PK_EST_NF_SAI_DAR_IT] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC,
	[CD_PROD] ASC,
	[CD_IT] ASC,
	[CD_DAR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_CD_DAR]  DEFAULT ((0)) FOR [CD_DAR]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_VLR_BASE_ICMS]  DEFAULT ((0)) FOR [VLR_BASE_ICMS]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_VLR_ICMS_SUBS]  DEFAULT ((0)) FOR [VLR_ICMS_SUBS]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_VLR_BASE_SUBS]  DEFAULT ((0)) FOR [VLR_BASE_SUBS]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_VLR_ICMS]  DEFAULT ((0)) FOR [VLR_ICMS]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_PERC_ICMS]  DEFAULT ((0)) FOR [PERC_ICMS]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_PERC_IVA]  DEFAULT ((0)) FOR [PERC_IVA]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_VLR_ICMS_DIFERENCIAL]  DEFAULT ((0)) FOR [VLR_ICMS_DIFERENCIAL]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_CD_TRIB]  DEFAULT ((0)) FOR [CD_TRIB]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_CD_NT_OP]  DEFAULT ((0)) FOR [CD_NT_OP]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_VLR_CUSTO]  DEFAULT ((0)) FOR [VLR_CUSTO]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_PERC_RED_BASE_ICMS]  DEFAULT ((0)) FOR [PERC_RED_BASE_ICMS]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_PERC_RED_BASE_SUBS]  DEFAULT ((0)) FOR [PERC_RED_BASE_SUBS]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_PERC_ICMS_DESTINO]  DEFAULT ((0)) FOR [PERC_ICMS_DESTINO]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_VLR_PMC]  DEFAULT ((0)) FOR [VLR_PMC]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_VLR_BASE_ICMS_RETIDO]  DEFAULT ((0)) FOR [VLR_BASE_ICMS_RETIDO]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] ADD  CONSTRAINT [DF_EST_NF_SAI_DAR_IT_VLR_ICMS_RETIDO]  DEFAULT ((0)) FOR [VLR_ICMS_RETIDO]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_DAR_IT_EST_NF_SAI_DAR] FOREIGN KEY([CD_EMP], [CD_DAR])
REFERENCES [dbo].[EST_NF_SAI_DAR] ([CD_EMP], [CD_DAR])

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] CHECK CONSTRAINT [FK_EST_NF_SAI_DAR_IT_EST_NF_SAI_DAR]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_DAR_IT_EST_NF_SAI_IT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD], [CD_IT])
REFERENCES [dbo].[EST_NF_SAI_IT] ([CD_EMP], [CD_FILIAL], [CD_NF], [CD_PROD], [CD_IT])

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] CHECK CONSTRAINT [FK_EST_NF_SAI_DAR_IT_EST_NF_SAI_IT]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_DAR_IT_EST_TRIB] FOREIGN KEY([CD_TRIB])
REFERENCES [dbo].[EST_TRIB] ([CD_TRIB])

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] CHECK CONSTRAINT [FK_EST_NF_SAI_DAR_IT_EST_TRIB]

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_DAR_IT_GLB_NT_OP] FOREIGN KEY([CD_NT_OP])
REFERENCES [dbo].[GLB_NT_OP] ([CD_NT_OP])

ALTER TABLE [dbo].[EST_NF_SAI_DAR_IT] CHECK CONSTRAINT [FK_EST_NF_SAI_DAR_IT_GLB_NT_OP]
end